/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.item;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class GuardianFruitItem
extends Item {
    public GuardianFruitItem(Item.Properties properties) {
        super(properties);
    }

    public ItemStack finishUsingItem(ItemStack itemStack, Level level, LivingEntity livingEntity) {
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            CriteriaTriggers.CONSUME_ITEM.trigger(serverPlayer, itemStack);
            serverPlayer.awardStat(Stats.ITEM_USED.get((Object)this));
        }
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!player.getAbilities().instabuild) {
                itemStack.shrink(1);
            }
        }
        if (!level.isClientSide()) {
            livingEntity.removeEffect(MobEffects.DIG_SLOWDOWN);
        }
        return super.finishUsingItem(itemStack, level, livingEntity);
    }
}

